/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import icyllis.modernui.ModernUI;
import icyllis.modernui.util.Pool;
import icyllis.modernui.util.Pools;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NetworkHandler {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Network");
    private final ResourceLocation mChannel;
    private final String mProtocol;
    private final boolean mOptional;
    @Nullable
    private final S2CMsgHandler mClientHandler;
    @Nullable
    private final C2SMsgHandler mServerHandler;
    protected final Pool<Broadcaster> mPool = Pools.concurrent(1);

    public NetworkHandler(@Nonnull String modid, @Nonnull String name, @Nonnull Supplier<Supplier<S2CMsgHandler>> clientHandler, @Nullable C2SMsgHandler serverHandler, @Nullable String protocol, boolean optional) {
        if (protocol == null || protocol.isEmpty()) {
            protocol = DigestUtils.md5Hex((byte[])ModList.get().getModFileById(modid).getMods().stream().map(iModInfo -> iModInfo.getVersion().getQualifier()).collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8));
        }
        this.mProtocol = protocol;
        this.mOptional = optional;
        this.mClientHandler = FMLEnvironment.dist.isClient() ? clientHandler.get().get() : null;
        this.mServerHandler = serverHandler;
        this.mChannel = new ResourceLocation(modid, name);
        EventNetworkChannel network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.mChannel).networkProtocolVersion(this::getProtocolVersion).clientAcceptedVersions(this::checkS2CProtocol).serverAcceptedVersions(this::checkC2SProtocol).eventNetworkChannel();
        if (FMLEnvironment.dist.isClient()) {
            network.addListener(this::onS2CMessageReceived);
        }
        network.addListener(this::onC2SMessageReceived);
    }

    public String getProtocolVersion() {
        return this.mProtocol;
    }

    private boolean checkS2CProtocol(@Nonnull String serverProtocol) {
        boolean allowAbsent;
        boolean bl = allowAbsent = this.mOptional && serverProtocol.equals(NetworkRegistry.ABSENT);
        if (allowAbsent) {
            ModernUI.LOGGER.debug(MARKER, "Connecting to a server that does not have {} channel available", (Object)this.mChannel);
        }
        return allowAbsent || serverProtocol.equals(this.mProtocol);
    }

    private boolean checkC2SProtocol(@Nonnull String clientProtocol) {
        if (clientProtocol.equals(NetworkRegistry.ACCEPTVANILLA)) {
            return false;
        }
        return clientProtocol.equals(this.mProtocol) || this.mOptional && clientProtocol.equals(NetworkRegistry.ABSENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onS2CMessageReceived(NetworkEvent.ServerCustomPayloadEvent event) {
        ClientPlayerEntity player;
        if (this.mClientHandler != null && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            this.mClientHandler.handle(event.getPayload().readShort(), event.getPayload(), player);
        }
        event.getPayload().release();
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    private void onC2SMessageReceived(NetworkEvent.ClientCustomPayloadEvent event) {
        ServerPlayerEntity player;
        if (this.mServerHandler != null && (player = ((NetworkEvent.Context)event.getSource().get()).getSender()) != null) {
            this.mServerHandler.handle(event.getPayload().readShort(), event.getPayload(), player);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    @Nonnull
    public PacketBuffer targetAt(int index) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeShort(index);
        return buffer;
    }

    @Nonnull
    public Broadcaster getBroadcaster(@Nonnull PacketBuffer buf) {
        Broadcaster b = this.mPool.acquire();
        if (b == null) {
            b = new Broadcaster();
        }
        b.buf = buf;
        return b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(@Nonnull PacketBuffer buf) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            connection.func_147297_a((IPacket)new CCustomPayloadPacket(this.mChannel, buf));
        }
    }

    @FunctionalInterface
    public static interface C2SMsgHandler {
        public void handle(short var1, @Nonnull PacketBuffer var2, @Nonnull ServerPlayerEntity var3);
    }

    @FunctionalInterface
    public static interface S2CMsgHandler {
        public void handle(short var1, @Nonnull PacketBuffer var2, @Nonnull ClientPlayerEntity var3);
    }

    public class Broadcaster {
        private PacketBuffer buf;

        protected void recycle() {
            this.buf = null;
            NetworkHandler.this.mPool.release(this);
        }

        public void sendToPlayer(@Nonnull PlayerEntity player) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.recycle();
        }

        public void sendToPlayer(@Nonnull ServerPlayerEntity player) {
            player.field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.recycle();
        }

        public void sendToPlayers(@Nonnull Iterable<? extends PlayerEntity> players) {
            SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf);
            for (PlayerEntity playerEntity : players) {
                ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a((IPacket)packet);
            }
            this.recycle();
        }

        public void sendToAll() {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148540_a((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.recycle();
        }

        public void sendToDimension(@Nonnull RegistryKey<World> dimension) {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232642_a_((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf), dimension);
            this.recycle();
        }

        public void sendToNearby(@Nullable ServerPlayerEntity excluded, double x, double y, double z, double radius, @Nonnull RegistryKey<World> dimension) {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148543_a((PlayerEntity)excluded, x, y, z, radius, dimension, (IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.recycle();
        }

        public void sendToTrackingEntity(@Nonnull Entity entity) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217218_b(entity, (IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.recycle();
        }

        public void sendToTrackingAndSelf(@Nonnull Entity entity) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a(entity, (IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.recycle();
        }

        public void sendToTrackingChunk(@Nonnull Chunk chunk) {
            SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf);
            ((ServerWorld)chunk.func_177412_p()).func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(arg_0 -> Broadcaster.lambda$sendToTrackingChunk$0((IPacket)packet, arg_0));
            this.recycle();
        }

        private static /* synthetic */ void lambda$sendToTrackingChunk$0(IPacket packet, ServerPlayerEntity player) {
            player.field_71135_a.func_147359_a(packet);
        }
    }
}

